<?php
/*
Plugin Name: Post Counter
Description: Show the number of posts with post title, date and post link in each selected category with in a specified date range. Use this short code to display the results [category_post_count_with_Title].
Version: 1.4
Author:  Basharat Ullah
*/
add_action('admin_menu', 'add_category_settings_page');
function add_category_settings_page() {
  add_options_page('Select the categories for post count', 'Select Category ', 'manage_options', 'category-shortcode-settings', 'category_settings_page');
}

function category_settings_page() {
  $categories = get_categories();
  $selected_categories = get_option('selected_categories');
  ?>
  <div class="wrap">
    <h2>Select the categories for post count</h2>
    <form method="post" action="options.php">
      <?php settings_fields('category_shortcode_settings'); ?>
      <?php do_settings_sections('category_shortcode_settings'); ?>
      <table class="form-table">
        <tr valign="top">
        <th scope="row">Categories: </th>
        <td>
        <?php foreach ($categories as $category) { ?>
          <label><input type="checkbox" name="selected_categories[]" value="<?php echo $category->term_id; ?>" <?php 
              if(!empty($selected_categories))
                echo checked(in_array($category->term_id, $selected_categories));?>> <?php echo $category->name; ?></label><br>
            <?php } ?>
        </td>
        </tr>
      </table>
      <?php submit_button(); ?>
    </form>
  </div>
  <?php
}
add_action('admin_init', 'register_category_shortcode_settings');
function register_category_shortcode_settings() {
  register_setting('category_shortcode_settings', 'selected_categories', 'sanitize_category_shortcode_settings');
}

function sanitize_category_shortcode_settings($input) {
  $selected_categories = isset($input) ? $input : array();
  return $selected_categories;
}

//  shortcode [category_post_count_with_Title] to display the category post count.
add_shortcode('category_post_count_with_Title', 'category_post_count_with_Title_shortcode');
function category_post_count_with_Title_shortcode() {
if (isset($_GET['start_date']) && isset($_GET['end_date'])) {
    $start_date = date('Y-m-d', strtotime($_GET['start_date']));
    $end_date = date('Y-m-d', strtotime($_GET['end_date']));
} else {
    // default setting is only current date.
    $start_date = date('Y-m-d', strtotime('-1 days'));
    $end_date = date('Y-m-d', strtotime('-1 days'));
}
$selected_categories = get_option('selected_categories');
  $categories = get_categories(array('include' => $selected_categories));
 ?><div style="width:800px; padding-left: 20px;">
<form>
<label for="start_date"><b>Start Date: </b></label>
<input type="text" id="start_date" name="start_date" style="width:200px;" value="<?php echo  $start_date  ?>">
<label for="end_date"><b>End Date:</b></label>
<input type="text" id="end_date" name="end_date" style="width:200px;" value="<?php echo $end_date ?>">
<input type="submit" value="Submit" style="width:100px; margin-left: 20px;">
</form>
</div>
<?php
$total_posts_count = 0;
$Count_category = 0;
foreach ($categories as $category) {
  $arr_args = array(
  'cat' => $category->term_id,
  'posts_per_page' => -1,
  'date_query' => array(
  array(
    'after' => $start_date,
    'before' => $end_date,
    'inclusive' => true,
      ),
    ),
  );
  
  $posts = get_posts($arr_args);
  $post_count = count($posts);  
  $count_cat = 1;  
  if ($post_count > 0){
    $Count_category++;
  }
  $total_posts_count = $post_count + $total_posts_count;
} echo '<h2><b>Total of '.$total_posts_count.' posts were published from '.$start_date.' to '.$end_date.'</b> In '.$Count_category.' categories </h2>';
?>
<table>
  <thead>
    <tr>
      <th>Category</th>
      <th>Publish Date</th>
      <th></th>
    </tr>
  </thead>
  <tbody>
    <?php
    foreach ($categories as $category) {
      $arr_args = array(
        'cat' => $category->term_id,
        'posts_per_page' => -1,
        'date_query' => array(
          array(
            'after' => $start_date,
            'before' => $end_date,
            'inclusive' => true,
          ),
        ),
      );
      $posts = get_posts($arr_args);
      $post_count = count($posts);
    ?>
      <tr style='background-color:#d0cfd3;'>
        <td style="font-size:16px; font-weight:bold;"><?php echo 'Category: '.$category->name.' ('. $post_count.') ' ; ?></td>
        <td></td>
        <td></td>
      </tr>
      <?php
      foreach ($posts as $post) {
        setup_postdata($post);
      ?>
        <tr>
          <td >
            <b>Post Title: </b><?php echo get_the_title($post->ID); ?>
            </td>
            <td>
            <b>Publish Date: </b><?php echo get_the_date('F j, Y', $post->ID); ?>
            </td>
            <td>
            <a href="<?php echo get_permalink($post->ID); ?>">View Post</a>
          </td>
        </tr>
    <?php
      }
    }
    ?>
  </tbody>
</table>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.min.js"></script>
<link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
<script>
    jQuery(document).ready(function($) {
        $("#start_date, #end_date").datepicker({
            dateFormat: 'yy-mm-dd'
        });
    });
</script>
<?php } ?>